%------------------------------------------------------------------------------
% File     : COM186^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Computing Theory
% Problem  : Grammars and languages 431
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : gram_lang__431.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.5.0, 0.33 v7.2.0, 0.50 v7.1.0
% Syntax   : Number of formulae    :  338 ( 133 unt;  57 typ;   0 def)
%            Number of atoms       :  726 ( 288 equ;   0 cnn)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives : 3861 (  99   ~;  13   |;  72   &;3356   @)
%                                         (   0 <=>; 321  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (   7 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  196 ( 196   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   57 (  54 usr;   5 con; 0-6 aty)
%            Number of variables   : 1022 (  37   ^; 886   !;  49   ?;1022   :)
%                                         (  50  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:42:38.131
%------------------------------------------------------------------------------
%----Could-be-implicit typings (8)
thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_Sum__Type_Osum,type,
    sum_sum: $tType > $tType > $tType ).

thf(ty_t_Option_Ooption,type,
    option: $tType > $tType ).

thf(ty_t_DTree_Odtree,type,
    dtree: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_DTree_OT,type,
    t: $tType ).

thf(ty_t_DTree_ON,type,
    n: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

%----Explicit typings (49)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder__bot,type,
    order_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Basic__BNFs_Osetl,type,
    basic_setl: 
      !>[A: $tType,B: $tType] : ( ( sum_sum @ A @ B ) > ( set @ A ) ) ).

thf(sy_c_Basic__BNFs_Osetr,type,
    basic_setr: 
      !>[A: $tType,B: $tType] : ( ( sum_sum @ A @ B ) > ( set @ B ) ) ).

thf(sy_c_DTree_ONode,type,
    node: n > ( set @ ( sum_sum @ t @ dtree ) ) > dtree ).

thf(sy_c_DTree_Ocont,type,
    cont: dtree > ( set @ ( sum_sum @ t @ dtree ) ) ).

thf(sy_c_DTree_Ocorec,type,
    corec: 
      !>[A: $tType] : ( ( A > n ) > ( A > ( set @ ( sum_sum @ t @ ( sum_sum @ dtree @ A ) ) ) ) > A > dtree ) ).

thf(sy_c_DTree_Odtree_Oroot,type,
    root: dtree > n ).

thf(sy_c_DTree_Ounfold,type,
    unfold: 
      !>[A: $tType] : ( ( A > n ) > ( A > ( set @ ( sum_sum @ t @ A ) ) ) > A > dtree ) ).

thf(sy_c_Finite__Set_Ofinite,type,
    finite_finite2: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinFr,type,
    gram_L1333338417e_inFr: ( set @ n ) > dtree > t > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinFr2,type,
    gram_L805317441_inFr2: ( set @ n ) > dtree > t > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinItr,type,
    gram_L830233218_inItr: ( set @ n ) > dtree > n > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Osubtr,type,
    gram_L716654942_subtr: ( set @ n ) > dtree > dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Osubtr2,type,
    gram_L1283001940subtr2: ( set @ n ) > dtree > dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OsubtrOf,type,
    gram_L1614515765ubtrOf: dtree > n > dtree ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Owf,type,
    gram_L864798063lle_wf: dtree > $o ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Relation_Oinv__imagep,type,
    inv_imagep: 
      !>[B: $tType,A: $tType] : ( ( B > B > $o ) > ( A > B ) > A > A > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_OPow,type,
    pow: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( set @ A ) ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__empty,type,
    is_empty: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Ois__singleton,type,
    is_singleton: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Oremove,type,
    remove: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Sum__Type_OInl,type,
    sum_Inl: 
      !>[A: $tType,B: $tType] : ( A > ( sum_sum @ A @ B ) ) ).

thf(sy_c_Sum__Type_OInr,type,
    sum_Inr: 
      !>[B: $tType,A: $tType] : ( B > ( sum_sum @ A @ B ) ) ).

thf(sy_c_Sum__Type_OPlus,type,
    sum_Plus: 
      !>[A: $tType,B: $tType] : ( ( set @ A ) > ( set @ B ) > ( set @ ( sum_sum @ A @ B ) ) ) ).

thf(sy_c_Sum__Type_OSuml,type,
    sum_Suml: 
      !>[A: $tType,C: $tType,B: $tType] : ( ( A > C ) > ( sum_sum @ A @ B ) > C ) ).

thf(sy_c_Sum__Type_OSumr,type,
    sum_Sumr: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( B > C ) > ( sum_sum @ A @ B ) > C ) ).

thf(sy_c_Sum__Type_Oold_Osum_Orec__sum,type,
    sum_rec_sum: 
      !>[A: $tType,T: $tType,B: $tType] : ( ( A > T ) > ( B > T ) > ( sum_sum @ A @ B ) > T ) ).

thf(sy_c_Sum__Type_Osum_Ocase__sum,type,
    sum_case_sum: 
      !>[A: $tType,C: $tType,B: $tType] : ( ( A > C ) > ( B > C ) > ( sum_sum @ A @ B ) > C ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_ns,type,
    ns: set @ n ).

thf(sy_v_tr,type,
    tr: dtree ).

thf(sy_v_tr1,type,
    tr1: dtree ).

%----Relevant facts (256)
thf(fact_0_assms_I1_J,axiom,
    gram_L864798063lle_wf @ tr1 ).

% assms(1)
thf(fact_1_assms_I2_J,axiom,
    gram_L716654942_subtr @ ns @ tr @ tr1 ).

% assms(2)
thf(fact_2_wf__cont,axiom,
    ! [Tr: dtree,Tr2: dtree] :
      ( ( gram_L864798063lle_wf @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr2 ) @ ( cont @ Tr ) )
       => ( gram_L864798063lle_wf @ Tr2 ) ) ) ).

% wf_cont
thf(fact_3_subtr__trans,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Tr3: dtree] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( ( gram_L716654942_subtr @ Ns @ Tr22 @ Tr3 )
       => ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr3 ) ) ) ).

% subtr_trans
thf(fact_4_sum_Oinject_I2_J,axiom,
    ! [A: $tType,B: $tType,X2: B,Y2: B] :
      ( ( ( sum_Inr @ B @ A @ X2 )
        = ( sum_Inr @ B @ A @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% sum.inject(2)
thf(fact_5_old_Osum_Oinject_I2_J,axiom,
    ! [A: $tType,B: $tType,B2: B,B3: B] :
      ( ( ( sum_Inr @ B @ A @ B2 )
        = ( sum_Inr @ B @ A @ B3 ) )
      = ( B2 = B3 ) ) ).

% old.sum.inject(2)
thf(fact_6_wf__inj,axiom,
    ! [Tr: dtree,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L864798063lle_wf @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr22 ) @ ( cont @ Tr ) )
         => ( ( ( root @ Tr1 )
              = ( root @ Tr22 ) )
            = ( Tr1 = Tr22 ) ) ) ) ) ).

% wf_inj
thf(fact_7_subtr__UNIV__inductL,axiom,
    ! [Tr1: dtree,Tr22: dtree,Phi: dtree > dtree > $o] :
      ( ( gram_L716654942_subtr @ ( top_top @ ( set @ n ) ) @ Tr1 @ Tr22 )
     => ( ! [Tr4: dtree] : ( Phi @ Tr4 @ Tr4 )
       => ( ! [Tr12: dtree,Tr23: dtree,Tr32: dtree] :
              ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr23 ) )
             => ( ( gram_L716654942_subtr @ ( top_top @ ( set @ n ) ) @ Tr23 @ Tr32 )
               => ( ( Phi @ Tr23 @ Tr32 )
                 => ( Phi @ Tr12 @ Tr32 ) ) ) )
         => ( Phi @ Tr1 @ Tr22 ) ) ) ) ).

% subtr_UNIV_inductL
thf(fact_8_Inr__inject,axiom,
    ! [A: $tType,B: $tType,X: B,Y: B] :
      ( ( ( sum_Inr @ B @ A @ X )
        = ( sum_Inr @ B @ A @ Y ) )
     => ( X = Y ) ) ).

% Inr_inject
thf(fact_9_not__arg__cong__Inr,axiom,
    ! [B: $tType,A: $tType,X: A,Y: A] :
      ( ( X != Y )
     => ( ( sum_Inr @ A @ B @ X )
       != ( sum_Inr @ A @ B @ Y ) ) ) ).

% not_arg_cong_Inr
thf(fact_10_subtr_OStep,axiom,
    ! [Tr3: dtree,Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( member @ n @ ( root @ Tr3 ) @ Ns )
     => ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
       => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr22 ) @ ( cont @ Tr3 ) )
         => ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr3 ) ) ) ) ).

% subtr.Step
thf(fact_11_subtr_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: dtree] :
      ( ( gram_L716654942_subtr @ A1 @ A2 @ A3 )
     => ( ( ( A3 = A2 )
         => ~ ( member @ n @ ( root @ A2 ) @ A1 ) )
       => ~ ( ( member @ n @ ( root @ A3 ) @ A1 )
           => ! [Tr23: dtree] :
                ( ( gram_L716654942_subtr @ A1 @ A2 @ Tr23 )
               => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr23 ) @ ( cont @ A3 ) ) ) ) ) ) ).

% subtr.cases
thf(fact_12_subtr_Osimps,axiom,
    ( gram_L716654942_subtr
    = ( ^ [A12: set @ n,A22: dtree,A32: dtree] :
          ( ? [Tr5: dtree,Ns2: set @ n] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr5 )
              & ( A32 = Tr5 )
              & ( member @ n @ ( root @ Tr5 ) @ Ns2 ) )
          | ? [Tr33: dtree,Ns2: set @ n,Tr13: dtree,Tr24: dtree] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr13 )
              & ( A32 = Tr33 )
              & ( member @ n @ ( root @ Tr33 ) @ Ns2 )
              & ( gram_L716654942_subtr @ Ns2 @ Tr13 @ Tr24 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr24 ) @ ( cont @ Tr33 ) ) ) ) ) ) ).

% subtr.simps
thf(fact_13_subtr__StepL,axiom,
    ! [Tr1: dtree,Ns: set @ n,Tr22: dtree,Tr3: dtree] :
      ( ( member @ n @ ( root @ Tr1 ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr22 ) )
       => ( ( gram_L716654942_subtr @ Ns @ Tr22 @ Tr3 )
         => ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr3 ) ) ) ) ).

% subtr_StepL
thf(fact_14_subtr_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: dtree,P: ( set @ n ) > dtree > dtree > $o] :
      ( ( gram_L716654942_subtr @ X1 @ X2 @ X3 )
     => ( ! [Tr4: dtree,Ns3: set @ n] :
            ( ( member @ n @ ( root @ Tr4 ) @ Ns3 )
           => ( P @ Ns3 @ Tr4 @ Tr4 ) )
       => ( ! [Tr32: dtree,Ns3: set @ n,Tr12: dtree,Tr23: dtree] :
              ( ( member @ n @ ( root @ Tr32 ) @ Ns3 )
             => ( ( gram_L716654942_subtr @ Ns3 @ Tr12 @ Tr23 )
               => ( ( P @ Ns3 @ Tr12 @ Tr23 )
                 => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr23 ) @ ( cont @ Tr32 ) )
                   => ( P @ Ns3 @ Tr12 @ Tr32 ) ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% subtr.inducts
thf(fact_15_subtr__inductL,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Phi: ( set @ n ) > dtree > dtree > $o] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( ! [Ns3: set @ n,Tr4: dtree] : ( Phi @ Ns3 @ Tr4 @ Tr4 )
       => ( ! [Ns3: set @ n,Tr12: dtree,Tr23: dtree,Tr32: dtree] :
              ( ( member @ n @ ( root @ Tr12 ) @ Ns3 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr23 ) )
               => ( ( gram_L716654942_subtr @ Ns3 @ Tr23 @ Tr32 )
                 => ( ( Phi @ Ns3 @ Tr23 @ Tr32 )
                   => ( Phi @ Ns3 @ Tr12 @ Tr32 ) ) ) ) )
         => ( Phi @ Ns @ Tr1 @ Tr22 ) ) ) ) ).

% subtr_inductL
thf(fact_16_subtr__rootR__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr22 ) @ Ns ) ) ).

% subtr_rootR_in
thf(fact_17_subtr__rootL__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr1 ) @ Ns ) ) ).

% subtr_rootL_in
thf(fact_18_subtr_ORefl,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( gram_L716654942_subtr @ Ns @ Tr @ Tr ) ) ).

% subtr.Refl
thf(fact_19_subtrOf__root,axiom,
    ! [Tr: dtree,Tr2: dtree] :
      ( ( gram_L864798063lle_wf @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr2 ) @ ( cont @ Tr ) )
       => ( ( gram_L1614515765ubtrOf @ Tr @ ( root @ Tr2 ) )
          = Tr2 ) ) ) ).

% subtrOf_root
thf(fact_20_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X: A] : ( member @ A @ X @ ( top_top @ ( set @ A ) ) ) ).

% iso_tuple_UNIV_I
thf(fact_21_UNIV__I,axiom,
    ! [A: $tType,X: A] : ( member @ A @ X @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_I
thf(fact_22_top__apply,axiom,
    ! [C: $tType,D: $tType] :
      ( ( top @ C @ ( type2 @ C ) )
     => ( ( top_top @ ( D > C ) )
        = ( ^ [X4: D] : ( top_top @ C ) ) ) ) ).

% top_apply
thf(fact_23_dtree__cong,axiom,
    ! [Tr: dtree,Tr2: dtree] :
      ( ( ( root @ Tr )
        = ( root @ Tr2 ) )
     => ( ( ( cont @ Tr )
          = ( cont @ Tr2 ) )
       => ( Tr = Tr2 ) ) ) ).

% dtree_cong
thf(fact_24_old_Osum_Osimps_I8_J,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > T,F2: B > T,B2: B] :
      ( ( sum_rec_sum @ A @ T @ B @ F1 @ F2 @ ( sum_Inr @ B @ A @ B2 ) )
      = ( F2 @ B2 ) ) ).

% old.sum.simps(8)
thf(fact_25_inFr2__Ind,axiom,
    ! [Ns: set @ n,Tr1: dtree,T2: t,Tr: dtree] :
      ( ( gram_L805317441_inFr2 @ Ns @ Tr1 @ T2 )
     => ( ( member @ n @ ( root @ Tr ) @ Ns )
       => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
         => ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 ) ) ) ) ).

% inFr2_Ind
thf(fact_26_inItr_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: n,P: ( set @ n ) > dtree > n > $o] :
      ( ( gram_L830233218_inItr @ X1 @ X2 @ X3 )
     => ( ! [Tr4: dtree,Ns3: set @ n] :
            ( ( member @ n @ ( root @ Tr4 ) @ Ns3 )
           => ( P @ Ns3 @ Tr4 @ ( root @ Tr4 ) ) )
       => ( ! [Tr4: dtree,Ns3: set @ n,Tr12: dtree,N: n] :
              ( ( member @ n @ ( root @ Tr4 ) @ Ns3 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr4 ) )
               => ( ( gram_L830233218_inItr @ Ns3 @ Tr12 @ N )
                 => ( ( P @ Ns3 @ Tr12 @ N )
                   => ( P @ Ns3 @ Tr4 @ N ) ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% inItr.inducts
thf(fact_27_inItr_Osimps,axiom,
    ( gram_L830233218_inItr
    = ( ^ [A12: set @ n,A22: dtree,A32: n] :
          ( ? [Tr5: dtree,Ns2: set @ n] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr5 )
              & ( A32
                = ( root @ Tr5 ) )
              & ( member @ n @ ( root @ Tr5 ) @ Ns2 ) )
          | ? [Tr5: dtree,Ns2: set @ n,Tr13: dtree,N2: n] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr5 )
              & ( A32 = N2 )
              & ( member @ n @ ( root @ Tr5 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr5 ) )
              & ( gram_L830233218_inItr @ Ns2 @ Tr13 @ N2 ) ) ) ) ) ).

% inItr.simps
thf(fact_28_inItr_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: n] :
      ( ( gram_L830233218_inItr @ A1 @ A2 @ A3 )
     => ( ( ( A3
            = ( root @ A2 ) )
         => ~ ( member @ n @ ( root @ A2 ) @ A1 ) )
       => ~ ( ( member @ n @ ( root @ A2 ) @ A1 )
           => ! [Tr12: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ A2 ) )
               => ~ ( gram_L830233218_inItr @ A1 @ Tr12 @ A3 ) ) ) ) ) ).

% inItr.cases
thf(fact_29_top__set__def,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( set @ A ) )
      = ( collect @ A @ ( top_top @ ( A > $o ) ) ) ) ).

% top_set_def
thf(fact_30_inItr_OBase,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( gram_L830233218_inItr @ Ns @ Tr @ ( root @ Tr ) ) ) ).

% inItr.Base
thf(fact_31_inItr__root__in,axiom,
    ! [Ns: set @ n,Tr: dtree,N3: n] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N3 )
     => ( member @ n @ ( root @ Tr ) @ Ns ) ) ).

% inItr_root_in
thf(fact_32_inFr2__root__in,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t] :
      ( ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 )
     => ( member @ n @ ( root @ Tr ) @ Ns ) ) ).

% inFr2_root_in
thf(fact_33_subtr__inItr,axiom,
    ! [Ns: set @ n,Tr: dtree,N3: n,Tr1: dtree] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N3 )
     => ( ( gram_L716654942_subtr @ Ns @ Tr @ Tr1 )
       => ( gram_L830233218_inItr @ Ns @ Tr1 @ N3 ) ) ) ).

% subtr_inItr
thf(fact_34_UNIV__eq__I,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ! [X5: A] : ( member @ A @ X5 @ A4 )
     => ( ( top_top @ ( set @ A ) )
        = A4 ) ) ).

% UNIV_eq_I
thf(fact_35_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X5: A] : ( member @ A @ X5 @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_witness
thf(fact_36_inItr__subtr,axiom,
    ! [Ns: set @ n,Tr: dtree,N3: n] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N3 )
     => ? [Tr6: dtree] :
          ( ( gram_L716654942_subtr @ Ns @ Tr6 @ Tr )
          & ( ( root @ Tr6 )
            = N3 ) ) ) ).

% inItr_subtr
thf(fact_37_inItr_OInd,axiom,
    ! [Tr: dtree,Ns: set @ n,Tr1: dtree,N3: n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( ( gram_L830233218_inItr @ Ns @ Tr1 @ N3 )
         => ( gram_L830233218_inItr @ Ns @ Tr @ N3 ) ) ) ) ).

% inItr.Ind
thf(fact_38_Node__root__cont,axiom,
    ! [Tr: dtree] :
      ( ( node @ ( root @ Tr ) @ ( cont @ Tr ) )
      = Tr ) ).

% Node_root_cont
thf(fact_39_inFr_OInd,axiom,
    ! [Tr: dtree,Ns: set @ n,Tr1: dtree,T2: t] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( ( gram_L1333338417e_inFr @ Ns @ Tr1 @ T2 )
         => ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 ) ) ) ) ).

% inFr.Ind
thf(fact_40_inFr2_OInd,axiom,
    ! [Tr1: dtree,Tr: dtree,Ns1: set @ n,T2: t] :
      ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
     => ( ( gram_L805317441_inFr2 @ Ns1 @ Tr1 @ T2 )
       => ( gram_L805317441_inFr2 @ ( insert @ n @ ( root @ Tr ) @ Ns1 ) @ Tr @ T2 ) ) ) ).

% inFr2.Ind
thf(fact_41_subtr2_OStep,axiom,
    ! [Tr1: dtree,Ns: set @ n,Tr22: dtree,Tr3: dtree] :
      ( ( member @ n @ ( root @ Tr1 ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr22 ) )
       => ( ( gram_L1283001940subtr2 @ Ns @ Tr22 @ Tr3 )
         => ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr3 ) ) ) ) ).

% subtr2.Step
thf(fact_42_subtr2_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: dtree] :
      ( ( gram_L1283001940subtr2 @ A1 @ A2 @ A3 )
     => ( ( ( A3 = A2 )
         => ~ ( member @ n @ ( root @ A2 ) @ A1 ) )
       => ~ ( ( member @ n @ ( root @ A2 ) @ A1 )
           => ! [Tr23: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ A2 ) @ ( cont @ Tr23 ) )
               => ~ ( gram_L1283001940subtr2 @ A1 @ Tr23 @ A3 ) ) ) ) ) ).

% subtr2.cases
thf(fact_43_subtr2_Osimps,axiom,
    ( gram_L1283001940subtr2
    = ( ^ [A12: set @ n,A22: dtree,A32: dtree] :
          ( ? [Tr5: dtree,Ns2: set @ n] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr5 )
              & ( A32 = Tr5 )
              & ( member @ n @ ( root @ Tr5 ) @ Ns2 ) )
          | ? [Tr13: dtree,Ns2: set @ n,Tr24: dtree,Tr33: dtree] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr13 )
              & ( A32 = Tr33 )
              & ( member @ n @ ( root @ Tr13 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr24 ) )
              & ( gram_L1283001940subtr2 @ Ns2 @ Tr24 @ Tr33 ) ) ) ) ) ).

% subtr2.simps
thf(fact_44_subtr2__StepR,axiom,
    ! [Tr3: dtree,Ns: set @ n,Tr22: dtree,Tr1: dtree] :
      ( ( member @ n @ ( root @ Tr3 ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr22 ) @ ( cont @ Tr3 ) )
       => ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
         => ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr3 ) ) ) ) ).

% subtr2_StepR
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A5: A,P: A > $o] :
      ( ( member @ A @ A5 @ ( collect @ A @ P ) )
      = ( P @ A5 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member @ A @ X4 @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X5: A] :
          ( ( P @ X5 )
          = ( Q @ X5 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X5: A] :
          ( ( F @ X5 )
          = ( G @ X5 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_subtr2_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: dtree,P: ( set @ n ) > dtree > dtree > $o] :
      ( ( gram_L1283001940subtr2 @ X1 @ X2 @ X3 )
     => ( ! [Tr4: dtree,Ns3: set @ n] :
            ( ( member @ n @ ( root @ Tr4 ) @ Ns3 )
           => ( P @ Ns3 @ Tr4 @ Tr4 ) )
       => ( ! [Tr12: dtree,Ns3: set @ n,Tr23: dtree,Tr32: dtree] :
              ( ( member @ n @ ( root @ Tr12 ) @ Ns3 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr23 ) )
               => ( ( gram_L1283001940subtr2 @ Ns3 @ Tr23 @ Tr32 )
                 => ( ( P @ Ns3 @ Tr23 @ Tr32 )
                   => ( P @ Ns3 @ Tr12 @ Tr32 ) ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% subtr2.inducts
thf(fact_50_root__Node,axiom,
    ! [N3: n,As: set @ ( sum_sum @ t @ dtree )] :
      ( ( root @ ( node @ N3 @ As ) )
      = N3 ) ).

% root_Node
thf(fact_51_insertCI,axiom,
    ! [A: $tType,A5: A,B4: set @ A,B2: A] :
      ( ( ~ ( member @ A @ A5 @ B4 )
       => ( A5 = B2 ) )
     => ( member @ A @ A5 @ ( insert @ A @ B2 @ B4 ) ) ) ).

% insertCI
thf(fact_52_insert__iff,axiom,
    ! [A: $tType,A5: A,B2: A,A4: set @ A] :
      ( ( member @ A @ A5 @ ( insert @ A @ B2 @ A4 ) )
      = ( ( A5 = B2 )
        | ( member @ A @ A5 @ A4 ) ) ) ).

% insert_iff
thf(fact_53_insert__absorb2,axiom,
    ! [A: $tType,X: A,A4: set @ A] :
      ( ( insert @ A @ X @ ( insert @ A @ X @ A4 ) )
      = ( insert @ A @ X @ A4 ) ) ).

% insert_absorb2
thf(fact_54_top1I,axiom,
    ! [A: $tType,X: A] : ( top_top @ ( A > $o ) @ X ) ).

% top1I
thf(fact_55_insertE,axiom,
    ! [A: $tType,A5: A,B2: A,A4: set @ A] :
      ( ( member @ A @ A5 @ ( insert @ A @ B2 @ A4 ) )
     => ( ( A5 != B2 )
       => ( member @ A @ A5 @ A4 ) ) ) ).

% insertE
thf(fact_56_insertI1,axiom,
    ! [A: $tType,A5: A,B4: set @ A] : ( member @ A @ A5 @ ( insert @ A @ A5 @ B4 ) ) ).

% insertI1
thf(fact_57_insertI2,axiom,
    ! [A: $tType,A5: A,B4: set @ A,B2: A] :
      ( ( member @ A @ A5 @ B4 )
     => ( member @ A @ A5 @ ( insert @ A @ B2 @ B4 ) ) ) ).

% insertI2
thf(fact_58_Set_Oset__insert,axiom,
    ! [A: $tType,X: A,A4: set @ A] :
      ( ( member @ A @ X @ A4 )
     => ~ ! [B5: set @ A] :
            ( ( A4
              = ( insert @ A @ X @ B5 ) )
           => ( member @ A @ X @ B5 ) ) ) ).

% Set.set_insert
thf(fact_59_insert__ident,axiom,
    ! [A: $tType,X: A,A4: set @ A,B4: set @ A] :
      ( ~ ( member @ A @ X @ A4 )
     => ( ~ ( member @ A @ X @ B4 )
       => ( ( ( insert @ A @ X @ A4 )
            = ( insert @ A @ X @ B4 ) )
          = ( A4 = B4 ) ) ) ) ).

% insert_ident
thf(fact_60_insert__absorb,axiom,
    ! [A: $tType,A5: A,A4: set @ A] :
      ( ( member @ A @ A5 @ A4 )
     => ( ( insert @ A @ A5 @ A4 )
        = A4 ) ) ).

% insert_absorb
thf(fact_61_insert__eq__iff,axiom,
    ! [A: $tType,A5: A,A4: set @ A,B2: A,B4: set @ A] :
      ( ~ ( member @ A @ A5 @ A4 )
     => ( ~ ( member @ A @ B2 @ B4 )
       => ( ( ( insert @ A @ A5 @ A4 )
            = ( insert @ A @ B2 @ B4 ) )
          = ( ( ( A5 = B2 )
             => ( A4 = B4 ) )
            & ( ( A5 != B2 )
             => ? [C2: set @ A] :
                  ( ( A4
                    = ( insert @ A @ B2 @ C2 ) )
                  & ~ ( member @ A @ B2 @ C2 )
                  & ( B4
                    = ( insert @ A @ A5 @ C2 ) )
                  & ~ ( member @ A @ A5 @ C2 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_62_insert__commute,axiom,
    ! [A: $tType,X: A,Y: A,A4: set @ A] :
      ( ( insert @ A @ X @ ( insert @ A @ Y @ A4 ) )
      = ( insert @ A @ Y @ ( insert @ A @ X @ A4 ) ) ) ).

% insert_commute
thf(fact_63_mk__disjoint__insert,axiom,
    ! [A: $tType,A5: A,A4: set @ A] :
      ( ( member @ A @ A5 @ A4 )
     => ? [B5: set @ A] :
          ( ( A4
            = ( insert @ A @ A5 @ B5 ) )
          & ~ ( member @ A @ A5 @ B5 ) ) ) ).

% mk_disjoint_insert
thf(fact_64_subtr2__trans,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Tr3: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( ( gram_L1283001940subtr2 @ Ns @ Tr22 @ Tr3 )
       => ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr3 ) ) ) ).

% subtr2_trans
thf(fact_65_insert__UNIV,axiom,
    ! [A: $tType,X: A] :
      ( ( insert @ A @ X @ ( top_top @ ( set @ A ) ) )
      = ( top_top @ ( set @ A ) ) ) ).

% insert_UNIV
thf(fact_66_subtr2__rootR__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr22 ) @ Ns ) ) ).

% subtr2_rootR_in
thf(fact_67_subtr2__rootL__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr1 ) @ Ns ) ) ).

% subtr2_rootL_in
thf(fact_68_subtr2_ORefl,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( gram_L1283001940subtr2 @ Ns @ Tr @ Tr ) ) ).

% subtr2.Refl
thf(fact_69_not__root__inFr,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ~ ( member @ n @ ( root @ Tr ) @ Ns )
     => ~ ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 ) ) ).

% not_root_inFr
thf(fact_70_inFr__root__in,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ( member @ n @ ( root @ Tr ) @ Ns ) ) ).

% inFr_root_in
thf(fact_71_subtr__subtr2,axiom,
    gram_L716654942_subtr = gram_L1283001940subtr2 ).

% subtr_subtr2
thf(fact_72_inFr__Ind__minus,axiom,
    ! [Ns1: set @ n,Tr1: dtree,T2: t,Tr: dtree] :
      ( ( gram_L1333338417e_inFr @ Ns1 @ Tr1 @ T2 )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( gram_L1333338417e_inFr @ ( insert @ n @ ( root @ Tr ) @ Ns1 ) @ Tr @ T2 ) ) ) ).

% inFr_Ind_minus
thf(fact_73_subtr__inFr,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t,Tr1: dtree] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ( ( gram_L716654942_subtr @ Ns @ Tr @ Tr1 )
       => ( gram_L1333338417e_inFr @ Ns @ Tr1 @ T2 ) ) ) ).

% subtr_inFr
thf(fact_74_inFr__inFr2,axiom,
    gram_L1333338417e_inFr = gram_L805317441_inFr2 ).

% inFr_inFr2
thf(fact_75_top__empty__eq,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( A > $o ) )
      = ( ^ [X4: A] : ( member @ A @ X4 @ ( top_top @ ( set @ A ) ) ) ) ) ).

% top_empty_eq
thf(fact_76_inFr2_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: t,P: ( set @ n ) > dtree > t > $o] :
      ( ( gram_L805317441_inFr2 @ X1 @ X2 @ X3 )
     => ( ! [Tr4: dtree,Ns3: set @ n,T3: t] :
            ( ( member @ n @ ( root @ Tr4 ) @ Ns3 )
           => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T3 ) @ ( cont @ Tr4 ) )
             => ( P @ Ns3 @ Tr4 @ T3 ) ) )
       => ( ! [Tr12: dtree,Tr4: dtree,Ns12: set @ n,T3: t] :
              ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr4 ) )
             => ( ( gram_L805317441_inFr2 @ Ns12 @ Tr12 @ T3 )
               => ( ( P @ Ns12 @ Tr12 @ T3 )
                 => ( P @ ( insert @ n @ ( root @ Tr4 ) @ Ns12 ) @ Tr4 @ T3 ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% inFr2.inducts
thf(fact_77_inFr2_Osimps,axiom,
    ( gram_L805317441_inFr2
    = ( ^ [A12: set @ n,A22: dtree,A32: t] :
          ( ? [Tr5: dtree,Ns2: set @ n,T4: t] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr5 )
              & ( A32 = T4 )
              & ( member @ n @ ( root @ Tr5 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T4 ) @ ( cont @ Tr5 ) ) )
          | ? [Tr13: dtree,Tr5: dtree,Ns13: set @ n,T4: t] :
              ( ( A12
                = ( insert @ n @ ( root @ Tr5 ) @ Ns13 ) )
              & ( A22 = Tr5 )
              & ( A32 = T4 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr5 ) )
              & ( gram_L805317441_inFr2 @ Ns13 @ Tr13 @ T4 ) ) ) ) ) ).

% inFr2.simps
thf(fact_78_inFr2_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: t] :
      ( ( gram_L805317441_inFr2 @ A1 @ A2 @ A3 )
     => ( ( ( member @ n @ ( root @ A2 ) @ A1 )
         => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ A3 ) @ ( cont @ A2 ) ) )
       => ~ ! [Tr12: dtree,Tr4: dtree,Ns12: set @ n] :
              ( ( A1
                = ( insert @ n @ ( root @ Tr4 ) @ Ns12 ) )
             => ( ( A2 = Tr4 )
               => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr4 ) )
                 => ~ ( gram_L805317441_inFr2 @ Ns12 @ Tr12 @ A3 ) ) ) ) ) ) ).

% inFr2.cases
thf(fact_79_top__conj_I1_J,axiom,
    ! [A: $tType,X: A,P: $o] :
      ( ( ( top_top @ ( A > $o ) @ X )
        & P )
      = P ) ).

% top_conj(1)
thf(fact_80_top__conj_I2_J,axiom,
    ! [A: $tType,P: $o,X: A] :
      ( ( P
        & ( top_top @ ( A > $o ) @ X ) )
      = P ) ).

% top_conj(2)
thf(fact_81_inFr_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: t,P: ( set @ n ) > dtree > t > $o] :
      ( ( gram_L1333338417e_inFr @ X1 @ X2 @ X3 )
     => ( ! [Tr4: dtree,Ns3: set @ n,T3: t] :
            ( ( member @ n @ ( root @ Tr4 ) @ Ns3 )
           => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T3 ) @ ( cont @ Tr4 ) )
             => ( P @ Ns3 @ Tr4 @ T3 ) ) )
       => ( ! [Tr4: dtree,Ns3: set @ n,Tr12: dtree,T3: t] :
              ( ( member @ n @ ( root @ Tr4 ) @ Ns3 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr4 ) )
               => ( ( gram_L1333338417e_inFr @ Ns3 @ Tr12 @ T3 )
                 => ( ( P @ Ns3 @ Tr12 @ T3 )
                   => ( P @ Ns3 @ Tr4 @ T3 ) ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% inFr.inducts
thf(fact_82_inFr_Osimps,axiom,
    ( gram_L1333338417e_inFr
    = ( ^ [A12: set @ n,A22: dtree,A32: t] :
          ( ? [Tr5: dtree,Ns2: set @ n,T4: t] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr5 )
              & ( A32 = T4 )
              & ( member @ n @ ( root @ Tr5 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T4 ) @ ( cont @ Tr5 ) ) )
          | ? [Tr5: dtree,Ns2: set @ n,Tr13: dtree,T4: t] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr5 )
              & ( A32 = T4 )
              & ( member @ n @ ( root @ Tr5 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr5 ) )
              & ( gram_L1333338417e_inFr @ Ns2 @ Tr13 @ T4 ) ) ) ) ) ).

% inFr.simps
thf(fact_83_old_Osum_Oinject_I1_J,axiom,
    ! [B: $tType,A: $tType,A5: A,A6: A] :
      ( ( ( sum_Inl @ A @ B @ A5 )
        = ( sum_Inl @ A @ B @ A6 ) )
      = ( A5 = A6 ) ) ).

% old.sum.inject(1)
thf(fact_84_sum_Oinject_I1_J,axiom,
    ! [B: $tType,A: $tType,X1: A,Y1: A] :
      ( ( ( sum_Inl @ A @ B @ X1 )
        = ( sum_Inl @ A @ B @ Y1 ) )
      = ( X1 = Y1 ) ) ).

% sum.inject(1)
thf(fact_85_Inr__Inl__False,axiom,
    ! [B: $tType,A: $tType,X: B,Y: A] :
      ( ( sum_Inr @ B @ A @ X )
     != ( sum_Inl @ A @ B @ Y ) ) ).

% Inr_Inl_False
thf(fact_86_Inl__Inr__False,axiom,
    ! [A: $tType,B: $tType,X: A,Y: B] :
      ( ( sum_Inl @ A @ B @ X )
     != ( sum_Inr @ B @ A @ Y ) ) ).

% Inl_Inr_False
thf(fact_87_old_Osum_Osimps_I7_J,axiom,
    ! [B: $tType,T: $tType,A: $tType,F1: A > T,F2: B > T,A5: A] :
      ( ( sum_rec_sum @ A @ T @ B @ F1 @ F2 @ ( sum_Inl @ A @ B @ A5 ) )
      = ( F1 @ A5 ) ) ).

% old.sum.simps(7)
thf(fact_88_obj__sumE__f,axiom,
    ! [A: $tType,C: $tType,B: $tType,S: B,F: ( sum_sum @ A @ C ) > B,P: $o] :
      ( ! [X5: A] :
          ( ( S
            = ( F @ ( sum_Inl @ A @ C @ X5 ) ) )
         => P )
     => ( ! [X5: C] :
            ( ( S
              = ( F @ ( sum_Inr @ C @ A @ X5 ) ) )
           => P )
       => ! [X6: sum_sum @ A @ C] :
            ( ( S
              = ( F @ X6 ) )
           => P ) ) ) ).

% obj_sumE_f
thf(fact_89_Inl__inject,axiom,
    ! [B: $tType,A: $tType,X: A,Y: A] :
      ( ( ( sum_Inl @ A @ B @ X )
        = ( sum_Inl @ A @ B @ Y ) )
     => ( X = Y ) ) ).

% Inl_inject
thf(fact_90_sum_Odistinct_I1_J,axiom,
    ! [A: $tType,B: $tType,X1: A,X2: B] :
      ( ( sum_Inl @ A @ B @ X1 )
     != ( sum_Inr @ B @ A @ X2 ) ) ).

% sum.distinct(1)
thf(fact_91_old_Osum_Odistinct_I2_J,axiom,
    ! [B6: $tType,A7: $tType,B7: B6,A8: A7] :
      ( ( sum_Inr @ B6 @ A7 @ B7 )
     != ( sum_Inl @ A7 @ B6 @ A8 ) ) ).

% old.sum.distinct(2)
thf(fact_92_old_Osum_Odistinct_I1_J,axiom,
    ! [A: $tType,B: $tType,A5: A,B3: B] :
      ( ( sum_Inl @ A @ B @ A5 )
     != ( sum_Inr @ B @ A @ B3 ) ) ).

% old.sum.distinct(1)
thf(fact_93_sumE,axiom,
    ! [A: $tType,B: $tType,S: sum_sum @ A @ B] :
      ( ! [X5: A] :
          ( S
         != ( sum_Inl @ A @ B @ X5 ) )
     => ~ ! [Y3: B] :
            ( S
           != ( sum_Inr @ B @ A @ Y3 ) ) ) ).

% sumE
thf(fact_94_Inr__not__Inl,axiom,
    ! [B: $tType,A: $tType,B2: B,A5: A] :
      ( ( sum_Inr @ B @ A @ B2 )
     != ( sum_Inl @ A @ B @ A5 ) ) ).

% Inr_not_Inl
thf(fact_95_split__sum__ex,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ^ [P2: ( sum_sum @ A @ B ) > $o] :
          ? [X7: sum_sum @ A @ B] : ( P2 @ X7 ) )
      = ( ^ [P3: ( sum_sum @ A @ B ) > $o] :
            ( ? [X4: A] : ( P3 @ ( sum_Inl @ A @ B @ X4 ) )
            | ? [X4: B] : ( P3 @ ( sum_Inr @ B @ A @ X4 ) ) ) ) ) ).

% split_sum_ex
thf(fact_96_split__sum__all,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ^ [P2: ( sum_sum @ A @ B ) > $o] :
          ! [X7: sum_sum @ A @ B] : ( P2 @ X7 ) )
      = ( ^ [P3: ( sum_sum @ A @ B ) > $o] :
            ( ! [X4: A] : ( P3 @ ( sum_Inl @ A @ B @ X4 ) )
            & ! [X4: B] : ( P3 @ ( sum_Inr @ B @ A @ X4 ) ) ) ) ) ).

% split_sum_all
thf(fact_97_old_Osum_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: sum_sum @ A @ B] :
      ( ! [A9: A] :
          ( Y
         != ( sum_Inl @ A @ B @ A9 ) )
     => ~ ! [B8: B] :
            ( Y
           != ( sum_Inr @ B @ A @ B8 ) ) ) ).

% old.sum.exhaust
thf(fact_98_old_Osum_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( sum_sum @ A @ B ) > $o,Sum: sum_sum @ A @ B] :
      ( ! [A9: A] : ( P @ ( sum_Inl @ A @ B @ A9 ) )
     => ( ! [B8: B] : ( P @ ( sum_Inr @ B @ A @ B8 ) )
       => ( P @ Sum ) ) ) ).

% old.sum.inducts
thf(fact_99_obj__sumE,axiom,
    ! [A: $tType,B: $tType,S: sum_sum @ A @ B] :
      ( ! [X5: A] :
          ( S
         != ( sum_Inl @ A @ B @ X5 ) )
     => ~ ! [X5: B] :
            ( S
           != ( sum_Inr @ B @ A @ X5 ) ) ) ).

% obj_sumE
thf(fact_100_inFr_OBase,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr ) )
       => ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 ) ) ) ).

% inFr.Base
thf(fact_101_inFr2_OBase,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr ) )
       => ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 ) ) ) ).

% inFr2.Base
thf(fact_102_inFr__subtr,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ? [Tr6: dtree] :
          ( ( gram_L716654942_subtr @ Ns @ Tr6 @ Tr )
          & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr6 ) ) ) ) ).

% inFr_subtr
thf(fact_103_inFr_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: t] :
      ( ( gram_L1333338417e_inFr @ A1 @ A2 @ A3 )
     => ( ( ( member @ n @ ( root @ A2 ) @ A1 )
         => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ A3 ) @ ( cont @ A2 ) ) )
       => ~ ( ( member @ n @ ( root @ A2 ) @ A1 )
           => ! [Tr12: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ A2 ) )
               => ~ ( gram_L1333338417e_inFr @ A1 @ Tr12 @ A3 ) ) ) ) ) ).

% inFr.cases
thf(fact_104_Suml_Osimps,axiom,
    ! [B: $tType,C: $tType,A: $tType,F: A > C,X: A] :
      ( ( sum_Suml @ A @ C @ B @ F @ ( sum_Inl @ A @ B @ X ) )
      = ( F @ X ) ) ).

% Suml.simps
thf(fact_105_Sumr_Osimps,axiom,
    ! [A: $tType,C: $tType,B: $tType,F: B > C,X: B] :
      ( ( sum_Sumr @ B @ C @ A @ F @ ( sum_Inr @ B @ A @ X ) )
      = ( F @ X ) ) ).

% Sumr.simps
thf(fact_106_corec_I1_J,axiom,
    ! [A: $tType,Rt: A > n,Ct: A > ( set @ ( sum_sum @ t @ ( sum_sum @ dtree @ A ) ) ),B2: A] :
      ( ( root @ ( corec @ A @ Rt @ Ct @ B2 ) )
      = ( Rt @ B2 ) ) ).

% corec(1)
thf(fact_107_unfold_I1_J,axiom,
    ! [A: $tType,Rt: A > n,Ct: A > ( set @ ( sum_sum @ t @ A ) ),B2: A] :
      ( ( root @ ( unfold @ A @ Rt @ Ct @ B2 ) )
      = ( Rt @ B2 ) ) ).

% unfold(1)
thf(fact_108_cont__Node,axiom,
    ! [As: set @ ( sum_sum @ t @ dtree ),N3: n] :
      ( ( finite_finite2 @ ( sum_sum @ t @ dtree ) @ As )
     => ( ( cont @ ( node @ N3 @ As ) )
        = As ) ) ).

% cont_Node
thf(fact_109_in__inv__imagep,axiom,
    ! [B: $tType,A: $tType] :
      ( ( inv_imagep @ A @ B )
      = ( ^ [R: A > A > $o,F3: B > A,X4: B,Y4: B] : ( R @ ( F3 @ X4 ) @ ( F3 @ Y4 ) ) ) ) ).

% in_inv_imagep
thf(fact_110_dtree__simps,axiom,
    ! [As: set @ ( sum_sum @ t @ dtree ),As2: set @ ( sum_sum @ t @ dtree ),N3: n,N4: n] :
      ( ( finite_finite2 @ ( sum_sum @ t @ dtree ) @ As )
     => ( ( finite_finite2 @ ( sum_sum @ t @ dtree ) @ As2 )
       => ( ( ( node @ N3 @ As )
            = ( node @ N4 @ As2 ) )
          = ( ( N3 = N4 )
            & ( As = As2 ) ) ) ) ) ).

% dtree_simps
thf(fact_111_Suml__inject,axiom,
    ! [B: $tType,C: $tType,A: $tType,F: A > C,G: A > C] :
      ( ( ( sum_Suml @ A @ C @ B @ F )
        = ( sum_Suml @ A @ C @ B @ G ) )
     => ( F = G ) ) ).

% Suml_inject
thf(fact_112_Sumr__inject,axiom,
    ! [A: $tType,C: $tType,B: $tType,F: B > C,G: B > C] :
      ( ( ( sum_Sumr @ B @ C @ A @ F )
        = ( sum_Sumr @ B @ C @ A @ G ) )
     => ( F = G ) ) ).

% Sumr_inject
thf(fact_113_finite__cont,axiom,
    ! [Tr: dtree] : ( finite_finite2 @ ( sum_sum @ t @ dtree ) @ ( cont @ Tr ) ) ).

% finite_cont
thf(fact_114_dtree__cases,axiom,
    ! [Tr: dtree] :
      ~ ! [N: n,As3: set @ ( sum_sum @ t @ dtree )] :
          ( ( finite_finite2 @ ( sum_sum @ t @ dtree ) @ As3 )
         => ( Tr
           != ( node @ N @ As3 ) ) ) ).

% dtree_cases
thf(fact_115_finite__Plus__UNIV__iff,axiom,
    ! [A: $tType,B: $tType] :
      ( ( finite_finite2 @ ( sum_sum @ A @ B ) @ ( top_top @ ( set @ ( sum_sum @ A @ B ) ) ) )
      = ( ( finite_finite2 @ A @ ( top_top @ ( set @ A ) ) )
        & ( finite_finite2 @ B @ ( top_top @ ( set @ B ) ) ) ) ) ).

% finite_Plus_UNIV_iff
thf(fact_116_finite__option__UNIV,axiom,
    ! [A: $tType] :
      ( ( finite_finite2 @ ( option @ A ) @ ( top_top @ ( set @ ( option @ A ) ) ) )
      = ( finite_finite2 @ A @ ( top_top @ ( set @ A ) ) ) ) ).

% finite_option_UNIV
thf(fact_117_finite__insert,axiom,
    ! [A: $tType,A5: A,A4: set @ A] :
      ( ( finite_finite2 @ A @ ( insert @ A @ A5 @ A4 ) )
      = ( finite_finite2 @ A @ A4 ) ) ).

% finite_insert
thf(fact_118_ex__new__if__finite,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ~ ( finite_finite2 @ A @ ( top_top @ ( set @ A ) ) )
     => ( ( finite_finite2 @ A @ A4 )
       => ? [A9: A] :
            ~ ( member @ A @ A9 @ A4 ) ) ) ).

% ex_new_if_finite
thf(fact_119_infinite__UNIV__char__0,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type2 @ A ) )
     => ~ ( finite_finite2 @ A @ ( top_top @ ( set @ A ) ) ) ) ).

% infinite_UNIV_char_0
thf(fact_120_finite__N,axiom,
    finite_finite2 @ n @ ( top_top @ ( set @ n ) ) ).

% finite_N
thf(fact_121_finite_OinsertI,axiom,
    ! [A: $tType,A4: set @ A,A5: A] :
      ( ( finite_finite2 @ A @ A4 )
     => ( finite_finite2 @ A @ ( insert @ A @ A5 @ A4 ) ) ) ).

% finite.insertI
thf(fact_122_finite__fun__UNIVD2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( finite_finite2 @ ( A > B ) @ ( top_top @ ( set @ ( A > B ) ) ) )
     => ( finite_finite2 @ B @ ( top_top @ ( set @ B ) ) ) ) ).

% finite_fun_UNIVD2
thf(fact_123_finite__Prod__UNIV,axiom,
    ! [B: $tType,A: $tType] :
      ( ( finite_finite2 @ A @ ( top_top @ ( set @ A ) ) )
     => ( ( finite_finite2 @ B @ ( top_top @ ( set @ B ) ) )
       => ( finite_finite2 @ ( product_prod @ A @ B ) @ ( top_top @ ( set @ ( product_prod @ A @ B ) ) ) ) ) ) ).

% finite_Prod_UNIV
thf(fact_124_finite__prod,axiom,
    ! [A: $tType,B: $tType] :
      ( ( finite_finite2 @ ( product_prod @ A @ B ) @ ( top_top @ ( set @ ( product_prod @ A @ B ) ) ) )
      = ( ( finite_finite2 @ A @ ( top_top @ ( set @ A ) ) )
        & ( finite_finite2 @ B @ ( top_top @ ( set @ B ) ) ) ) ) ).

% finite_prod
thf(fact_125_Finite__Set_Ofinite__set,axiom,
    ! [A: $tType] :
      ( ( finite_finite2 @ ( set @ A ) @ ( top_top @ ( set @ ( set @ A ) ) ) )
      = ( finite_finite2 @ A @ ( top_top @ ( set @ A ) ) ) ) ).

% Finite_Set.finite_set
thf(fact_126_finite__UNIV,axiom,
    ! [A: $tType] :
      ( ( finite_finite @ A @ ( type2 @ A ) )
     => ( finite_finite2 @ A @ ( top_top @ ( set @ A ) ) ) ) ).

% finite_UNIV
thf(fact_127_UNIV__Plus__UNIV,axiom,
    ! [B: $tType,A: $tType] :
      ( ( sum_Plus @ A @ B @ ( top_top @ ( set @ A ) ) @ ( top_top @ ( set @ B ) ) )
      = ( top_top @ ( set @ ( sum_sum @ A @ B ) ) ) ) ).

% UNIV_Plus_UNIV
thf(fact_128_case__sum__if,axiom,
    ! [B: $tType,A: $tType,C: $tType,P4: $o,F: B > A,G: C > A,X: B,Y: C] :
      ( ( P4
       => ( ( sum_case_sum @ B @ A @ C @ F @ G @ ( if @ ( sum_sum @ B @ C ) @ P4 @ ( sum_Inl @ B @ C @ X ) @ ( sum_Inr @ C @ B @ Y ) ) )
          = ( F @ X ) ) )
      & ( ~ P4
       => ( ( sum_case_sum @ B @ A @ C @ F @ G @ ( if @ ( sum_sum @ B @ C ) @ P4 @ ( sum_Inl @ B @ C @ X ) @ ( sum_Inr @ C @ B @ Y ) ) )
          = ( G @ Y ) ) ) ) ).

% case_sum_if
thf(fact_129_finite__compl,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( finite_finite2 @ A @ A4 )
     => ( ( finite_finite2 @ A @ ( uminus_uminus @ ( set @ A ) @ A4 ) )
        = ( finite_finite2 @ A @ ( top_top @ ( set @ A ) ) ) ) ) ).

% finite_compl
thf(fact_130_finite__Diff__insert,axiom,
    ! [A: $tType,A4: set @ A,A5: A,B4: set @ A] :
      ( ( finite_finite2 @ A @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A5 @ B4 ) ) )
      = ( finite_finite2 @ A @ ( minus_minus @ ( set @ A ) @ A4 @ B4 ) ) ) ).

% finite_Diff_insert
thf(fact_131_DiffI,axiom,
    ! [A: $tType,C3: A,A4: set @ A,B4: set @ A] :
      ( ( member @ A @ C3 @ A4 )
     => ( ~ ( member @ A @ C3 @ B4 )
       => ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A4 @ B4 ) ) ) ) ).

% DiffI
thf(fact_132_Diff__iff,axiom,
    ! [A: $tType,C3: A,A4: set @ A,B4: set @ A] :
      ( ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A4 @ B4 ) )
      = ( ( member @ A @ C3 @ A4 )
        & ~ ( member @ A @ C3 @ B4 ) ) ) ).

% Diff_iff
thf(fact_133_Diff__idemp,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ B4 ) @ B4 )
      = ( minus_minus @ ( set @ A ) @ A4 @ B4 ) ) ).

% Diff_idemp
thf(fact_134_ComplI,axiom,
    ! [A: $tType,C3: A,A4: set @ A] :
      ( ~ ( member @ A @ C3 @ A4 )
     => ( member @ A @ C3 @ ( uminus_uminus @ ( set @ A ) @ A4 ) ) ) ).

% ComplI
thf(fact_135_Compl__iff,axiom,
    ! [A: $tType,C3: A,A4: set @ A] :
      ( ( member @ A @ C3 @ ( uminus_uminus @ ( set @ A ) @ A4 ) )
      = ( ~ ( member @ A @ C3 @ A4 ) ) ) ).

% Compl_iff
thf(fact_136_Compl__eq__Compl__iff,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ( uminus_uminus @ ( set @ A ) @ A4 )
        = ( uminus_uminus @ ( set @ A ) @ B4 ) )
      = ( A4 = B4 ) ) ).

% Compl_eq_Compl_iff
thf(fact_137_Diff__insert0,axiom,
    ! [A: $tType,X: A,A4: set @ A,B4: set @ A] :
      ( ~ ( member @ A @ X @ A4 )
     => ( ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ X @ B4 ) )
        = ( minus_minus @ ( set @ A ) @ A4 @ B4 ) ) ) ).

% Diff_insert0
thf(fact_138_insert__Diff1,axiom,
    ! [A: $tType,X: A,B4: set @ A,A4: set @ A] :
      ( ( member @ A @ X @ B4 )
     => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ B4 )
        = ( minus_minus @ ( set @ A ) @ A4 @ B4 ) ) ) ).

% insert_Diff1
thf(fact_139_InrI,axiom,
    ! [B: $tType,A: $tType,B2: A,B4: set @ A,A4: set @ B] :
      ( ( member @ A @ B2 @ B4 )
     => ( member @ ( sum_sum @ B @ A ) @ ( sum_Inr @ A @ B @ B2 ) @ ( sum_Plus @ B @ A @ A4 @ B4 ) ) ) ).

% InrI
thf(fact_140_InlI,axiom,
    ! [A: $tType,B: $tType,A5: A,A4: set @ A,B4: set @ B] :
      ( ( member @ A @ A5 @ A4 )
     => ( member @ ( sum_sum @ A @ B ) @ ( sum_Inl @ A @ B @ A5 ) @ ( sum_Plus @ A @ B @ A4 @ B4 ) ) ) ).

% InlI
thf(fact_141_Compl__eq__Diff__UNIV,axiom,
    ! [A: $tType] :
      ( ( uminus_uminus @ ( set @ A ) )
      = ( minus_minus @ ( set @ A ) @ ( top_top @ ( set @ A ) ) ) ) ).

% Compl_eq_Diff_UNIV
thf(fact_142_case__sum__step_I2_J,axiom,
    ! [E: $tType,A: $tType,C: $tType,B: $tType,F: E > A,F4: B > A,G2: C > A,P4: sum_sum @ B @ C] :
      ( ( sum_case_sum @ E @ A @ ( sum_sum @ B @ C ) @ F @ ( sum_case_sum @ B @ A @ C @ F4 @ G2 ) @ ( sum_Inr @ ( sum_sum @ B @ C ) @ E @ P4 ) )
      = ( sum_case_sum @ B @ A @ C @ F4 @ G2 @ P4 ) ) ).

% case_sum_step(2)
thf(fact_143_DiffE,axiom,
    ! [A: $tType,C3: A,A4: set @ A,B4: set @ A] :
      ( ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A4 @ B4 ) )
     => ~ ( ( member @ A @ C3 @ A4 )
         => ( member @ A @ C3 @ B4 ) ) ) ).

% DiffE
thf(fact_144_ComplD,axiom,
    ! [A: $tType,C3: A,A4: set @ A] :
      ( ( member @ A @ C3 @ ( uminus_uminus @ ( set @ A ) @ A4 ) )
     => ~ ( member @ A @ C3 @ A4 ) ) ).

% ComplD
thf(fact_145_DiffD1,axiom,
    ! [A: $tType,C3: A,A4: set @ A,B4: set @ A] :
      ( ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A4 @ B4 ) )
     => ( member @ A @ C3 @ A4 ) ) ).

% DiffD1
thf(fact_146_DiffD2,axiom,
    ! [A: $tType,C3: A,A4: set @ A,B4: set @ A] :
      ( ( member @ A @ C3 @ ( minus_minus @ ( set @ A ) @ A4 @ B4 ) )
     => ~ ( member @ A @ C3 @ B4 ) ) ).

% DiffD2
thf(fact_147_double__complement,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( uminus_uminus @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ A4 ) )
      = A4 ) ).

% double_complement
thf(fact_148_case__sum__inject,axiom,
    ! [A: $tType,C: $tType,B: $tType,F1: A > C,F2: B > C,G1: A > C,G22: B > C] :
      ( ( ( sum_case_sum @ A @ C @ B @ F1 @ F2 )
        = ( sum_case_sum @ A @ C @ B @ G1 @ G22 ) )
     => ~ ( ( F1 = G1 )
         => ( F2 != G22 ) ) ) ).

% case_sum_inject
thf(fact_149_insert__Diff__if,axiom,
    ! [A: $tType,X: A,B4: set @ A,A4: set @ A] :
      ( ( ( member @ A @ X @ B4 )
       => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ B4 )
          = ( minus_minus @ ( set @ A ) @ A4 @ B4 ) ) )
      & ( ~ ( member @ A @ X @ B4 )
       => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ B4 )
          = ( insert @ A @ X @ ( minus_minus @ ( set @ A ) @ A4 @ B4 ) ) ) ) ) ).

% insert_Diff_if
thf(fact_150_case__sum__step_I1_J,axiom,
    ! [D: $tType,A: $tType,C: $tType,B: $tType,F4: B > A,G2: C > A,G: D > A,P4: sum_sum @ B @ C] :
      ( ( sum_case_sum @ ( sum_sum @ B @ C ) @ A @ D @ ( sum_case_sum @ B @ A @ C @ F4 @ G2 ) @ G @ ( sum_Inl @ ( sum_sum @ B @ C ) @ D @ P4 ) )
      = ( sum_case_sum @ B @ A @ C @ F4 @ G2 @ P4 ) ) ).

% case_sum_step(1)
thf(fact_151_old_Osum_Osimps_I6_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,F1: A > C,F2: B > C,X2: B] :
      ( ( sum_case_sum @ A @ C @ B @ F1 @ F2 @ ( sum_Inr @ B @ A @ X2 ) )
      = ( F2 @ X2 ) ) ).

% old.sum.simps(6)
thf(fact_152_old_Osum_Osimps_I5_J,axiom,
    ! [B: $tType,C: $tType,A: $tType,F1: A > C,F2: B > C,X1: A] :
      ( ( sum_case_sum @ A @ C @ B @ F1 @ F2 @ ( sum_Inl @ A @ B @ X1 ) )
      = ( F1 @ X1 ) ) ).

% old.sum.simps(5)
thf(fact_153_PlusE,axiom,
    ! [A: $tType,B: $tType,U: sum_sum @ A @ B,A4: set @ A,B4: set @ B] :
      ( ( member @ ( sum_sum @ A @ B ) @ U @ ( sum_Plus @ A @ B @ A4 @ B4 ) )
     => ( ! [X5: A] :
            ( ( member @ A @ X5 @ A4 )
           => ( U
             != ( sum_Inl @ A @ B @ X5 ) ) )
       => ~ ! [Y3: B] :
              ( ( member @ B @ Y3 @ B4 )
             => ( U
               != ( sum_Inr @ B @ A @ Y3 ) ) ) ) ) ).

% PlusE
thf(fact_154_Pow__UNIV,axiom,
    ! [A: $tType] :
      ( ( pow @ A @ ( top_top @ ( set @ A ) ) )
      = ( top_top @ ( set @ ( set @ A ) ) ) ) ).

% Pow_UNIV
thf(fact_155_Compl__insert,axiom,
    ! [A: $tType,X: A,A4: set @ A] :
      ( ( uminus_uminus @ ( set @ A ) @ ( insert @ A @ X @ A4 ) )
      = ( minus_minus @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ A4 ) @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Compl_insert
thf(fact_156_finite__empty__induct,axiom,
    ! [A: $tType,A4: set @ A,P: ( set @ A ) > $o] :
      ( ( finite_finite2 @ A @ A4 )
     => ( ( P @ A4 )
       => ( ! [A9: A,A10: set @ A] :
              ( ( finite_finite2 @ A @ A10 )
             => ( ( member @ A @ A9 @ A10 )
               => ( ( P @ A10 )
                 => ( P @ ( minus_minus @ ( set @ A ) @ A10 @ ( insert @ A @ A9 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) )
         => ( P @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% finite_empty_induct
thf(fact_157_infinite__coinduct,axiom,
    ! [A: $tType,X8: ( set @ A ) > $o,A4: set @ A] :
      ( ( X8 @ A4 )
     => ( ! [A10: set @ A] :
            ( ( X8 @ A10 )
           => ? [X6: A] :
                ( ( member @ A @ X6 @ A10 )
                & ( ( X8 @ ( minus_minus @ ( set @ A ) @ A10 @ ( insert @ A @ X6 @ ( bot_bot @ ( set @ A ) ) ) ) )
                  | ~ ( finite_finite2 @ A @ ( minus_minus @ ( set @ A ) @ A10 @ ( insert @ A @ X6 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) )
       => ~ ( finite_finite2 @ A @ A4 ) ) ) ).

% infinite_coinduct
thf(fact_158_bot__apply,axiom,
    ! [C: $tType,D: $tType] :
      ( ( bot @ C @ ( type2 @ C ) )
     => ( ( bot_bot @ ( D > C ) )
        = ( ^ [X4: D] : ( bot_bot @ C ) ) ) ) ).

% bot_apply
thf(fact_159_empty__Collect__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( collect @ A @ P ) )
      = ( ! [X4: A] :
            ~ ( P @ X4 ) ) ) ).

% empty_Collect_eq
thf(fact_160_Collect__empty__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X4: A] :
            ~ ( P @ X4 ) ) ) ).

% Collect_empty_eq
thf(fact_161_all__not__in__conv,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( ! [X4: A] :
            ~ ( member @ A @ X4 @ A4 ) )
      = ( A4
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% all_not_in_conv
thf(fact_162_empty__iff,axiom,
    ! [A: $tType,C3: A] :
      ~ ( member @ A @ C3 @ ( bot_bot @ ( set @ A ) ) ) ).

% empty_iff
thf(fact_163_singletonI,axiom,
    ! [A: $tType,A5: A] : ( member @ A @ A5 @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singletonI
thf(fact_164_Diff__cancel,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A4 @ A4 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Diff_cancel
thf(fact_165_empty__Diff,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ A4 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% empty_Diff
thf(fact_166_Diff__empty,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A4 @ ( bot_bot @ ( set @ A ) ) )
      = A4 ) ).

% Diff_empty
thf(fact_167_Plus__eq__empty__conv,axiom,
    ! [A: $tType,B: $tType,A4: set @ A,B4: set @ B] :
      ( ( ( sum_Plus @ A @ B @ A4 @ B4 )
        = ( bot_bot @ ( set @ ( sum_sum @ A @ B ) ) ) )
      = ( ( A4
          = ( bot_bot @ ( set @ A ) ) )
        & ( B4
          = ( bot_bot @ ( set @ B ) ) ) ) ) ).

% Plus_eq_empty_conv
thf(fact_168_Pow__singleton__iff,axiom,
    ! [A: $tType,X8: set @ A,Y5: set @ A] :
      ( ( ( pow @ A @ X8 )
        = ( insert @ ( set @ A ) @ Y5 @ ( bot_bot @ ( set @ ( set @ A ) ) ) ) )
      = ( ( X8
          = ( bot_bot @ ( set @ A ) ) )
        & ( Y5
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Pow_singleton_iff
thf(fact_169_Pow__empty,axiom,
    ! [A: $tType] :
      ( ( pow @ A @ ( bot_bot @ ( set @ A ) ) )
      = ( insert @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ ( bot_bot @ ( set @ ( set @ A ) ) ) ) ) ).

% Pow_empty
thf(fact_170_insert__Diff__single,axiom,
    ! [A: $tType,A5: A,A4: set @ A] :
      ( ( insert @ A @ A5 @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( insert @ A @ A5 @ A4 ) ) ).

% insert_Diff_single
thf(fact_171_Diff__UNIV,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A4 @ ( top_top @ ( set @ A ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Diff_UNIV
thf(fact_172_empty__not__UNIV,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
     != ( top_top @ ( set @ A ) ) ) ).

% empty_not_UNIV
thf(fact_173_bot__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot @ B @ ( type2 @ B ) )
     => ( ( bot_bot @ ( A > B ) )
        = ( ^ [X4: A] : ( bot_bot @ B ) ) ) ) ).

% bot_fun_def
thf(fact_174_Pow__not__empty,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( pow @ A @ A4 )
     != ( bot_bot @ ( set @ ( set @ A ) ) ) ) ).

% Pow_not_empty
thf(fact_175_ex__in__conv,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( ? [X4: A] : ( member @ A @ X4 @ A4 ) )
      = ( A4
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% ex_in_conv
thf(fact_176_Pow__bottom,axiom,
    ! [A: $tType,B4: set @ A] : ( member @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ ( pow @ A @ B4 ) ) ).

% Pow_bottom
thf(fact_177_equals0I,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ! [Y3: A] :
          ~ ( member @ A @ Y3 @ A4 )
     => ( A4
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% equals0I
thf(fact_178_equals0D,axiom,
    ! [A: $tType,A4: set @ A,A5: A] :
      ( ( A4
        = ( bot_bot @ ( set @ A ) ) )
     => ~ ( member @ A @ A5 @ A4 ) ) ).

% equals0D
thf(fact_179_Pow__top,axiom,
    ! [A: $tType,A4: set @ A] : ( member @ ( set @ A ) @ A4 @ ( pow @ A @ A4 ) ) ).

% Pow_top
thf(fact_180_emptyE,axiom,
    ! [A: $tType,A5: A] :
      ~ ( member @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) ).

% emptyE
thf(fact_181_singletonD,axiom,
    ! [A: $tType,B2: A,A5: A] :
      ( ( member @ A @ B2 @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( B2 = A5 ) ) ).

% singletonD
thf(fact_182_singleton__iff,axiom,
    ! [A: $tType,B2: A,A5: A] :
      ( ( member @ A @ B2 @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( B2 = A5 ) ) ).

% singleton_iff
thf(fact_183_doubleton__eq__iff,axiom,
    ! [A: $tType,A5: A,B2: A,C3: A,D2: A] :
      ( ( ( insert @ A @ A5 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( insert @ A @ C3 @ ( insert @ A @ D2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ( ( A5 = C3 )
          & ( B2 = D2 ) )
        | ( ( A5 = D2 )
          & ( B2 = C3 ) ) ) ) ).

% doubleton_eq_iff
thf(fact_184_insert__not__empty,axiom,
    ! [A: $tType,A5: A,A4: set @ A] :
      ( ( insert @ A @ A5 @ A4 )
     != ( bot_bot @ ( set @ A ) ) ) ).

% insert_not_empty
thf(fact_185_singleton__inject,axiom,
    ! [A: $tType,A5: A,B2: A] :
      ( ( ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( A5 = B2 ) ) ).

% singleton_inject
thf(fact_186_finite_Ocases,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( finite_finite2 @ A @ A5 )
     => ( ( A5
         != ( bot_bot @ ( set @ A ) ) )
       => ~ ! [A10: set @ A] :
              ( ? [A9: A] :
                  ( A5
                  = ( insert @ A @ A9 @ A10 ) )
             => ~ ( finite_finite2 @ A @ A10 ) ) ) ) ).

% finite.cases
thf(fact_187_finite_Osimps,axiom,
    ! [A: $tType] :
      ( ( finite_finite2 @ A )
      = ( ^ [A11: set @ A] :
            ( ( A11
              = ( bot_bot @ ( set @ A ) ) )
            | ? [A13: set @ A,B9: A] :
                ( ( A11
                  = ( insert @ A @ B9 @ A13 ) )
                & ( finite_finite2 @ A @ A13 ) ) ) ) ) ).

% finite.simps
thf(fact_188_finite__induct,axiom,
    ! [A: $tType,F5: set @ A,P: ( set @ A ) > $o] :
      ( ( finite_finite2 @ A @ F5 )
     => ( ( P @ ( bot_bot @ ( set @ A ) ) )
       => ( ! [X5: A,F6: set @ A] :
              ( ( finite_finite2 @ A @ F6 )
             => ( ~ ( member @ A @ X5 @ F6 )
               => ( ( P @ F6 )
                 => ( P @ ( insert @ A @ X5 @ F6 ) ) ) ) )
         => ( P @ F5 ) ) ) ) ).

% finite_induct
thf(fact_189_finite_Oinducts,axiom,
    ! [A: $tType,X: set @ A,P: ( set @ A ) > $o] :
      ( ( finite_finite2 @ A @ X )
     => ( ( P @ ( bot_bot @ ( set @ A ) ) )
       => ( ! [A10: set @ A,A9: A] :
              ( ( finite_finite2 @ A @ A10 )
             => ( ( P @ A10 )
               => ( P @ ( insert @ A @ A9 @ A10 ) ) ) )
         => ( P @ X ) ) ) ) ).

% finite.inducts
thf(fact_190_finite__ne__induct,axiom,
    ! [A: $tType,F5: set @ A,P: ( set @ A ) > $o] :
      ( ( finite_finite2 @ A @ F5 )
     => ( ( F5
         != ( bot_bot @ ( set @ A ) ) )
       => ( ! [X5: A] : ( P @ ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) )
         => ( ! [X5: A,F6: set @ A] :
                ( ( finite_finite2 @ A @ F6 )
               => ( ( F6
                   != ( bot_bot @ ( set @ A ) ) )
                 => ( ~ ( member @ A @ X5 @ F6 )
                   => ( ( P @ F6 )
                     => ( P @ ( insert @ A @ X5 @ F6 ) ) ) ) ) )
           => ( P @ F5 ) ) ) ) ) ).

% finite_ne_induct
thf(fact_191_infinite__finite__induct,axiom,
    ! [A: $tType,P: ( set @ A ) > $o,A4: set @ A] :
      ( ! [A10: set @ A] :
          ( ~ ( finite_finite2 @ A @ A10 )
         => ( P @ A10 ) )
     => ( ( P @ ( bot_bot @ ( set @ A ) ) )
       => ( ! [X5: A,F6: set @ A] :
              ( ( finite_finite2 @ A @ F6 )
             => ( ~ ( member @ A @ X5 @ F6 )
               => ( ( P @ F6 )
                 => ( P @ ( insert @ A @ X5 @ F6 ) ) ) ) )
         => ( P @ A4 ) ) ) ) ).

% infinite_finite_induct
thf(fact_192_Diff__insert__absorb,axiom,
    ! [A: $tType,X: A,A4: set @ A] :
      ( ~ ( member @ A @ X @ A4 )
     => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
        = A4 ) ) ).

% Diff_insert_absorb
thf(fact_193_Diff__insert2,axiom,
    ! [A: $tType,A4: set @ A,A5: A,B4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A5 @ B4 ) )
      = ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) ) @ B4 ) ) ).

% Diff_insert2
thf(fact_194_insert__Diff,axiom,
    ! [A: $tType,A5: A,A4: set @ A] :
      ( ( member @ A @ A5 @ A4 )
     => ( ( insert @ A @ A5 @ ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) ) )
        = A4 ) ) ).

% insert_Diff
thf(fact_195_Diff__insert,axiom,
    ! [A: $tType,A4: set @ A,A5: A,B4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A4 @ ( insert @ A @ A5 @ B4 ) )
      = ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A4 @ B4 ) @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Diff_insert
thf(fact_196_Compl__UNIV__eq,axiom,
    ! [A: $tType] :
      ( ( uminus_uminus @ ( set @ A ) @ ( top_top @ ( set @ A ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Compl_UNIV_eq
thf(fact_197_Compl__empty__eq,axiom,
    ! [A: $tType] :
      ( ( uminus_uminus @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) )
      = ( top_top @ ( set @ A ) ) ) ).

% Compl_empty_eq
thf(fact_198_infinite__remove,axiom,
    ! [A: $tType,S2: set @ A,A5: A] :
      ( ~ ( finite_finite2 @ A @ S2 )
     => ~ ( finite_finite2 @ A @ ( minus_minus @ ( set @ A ) @ S2 @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% infinite_remove
thf(fact_199_compl__bot__eq,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ( ( uminus_uminus @ A @ ( bot_bot @ A ) )
        = ( top_top @ A ) ) ) ).

% compl_bot_eq
thf(fact_200_compl__top__eq,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A @ ( type2 @ A ) )
     => ( ( uminus_uminus @ A @ ( top_top @ A ) )
        = ( bot_bot @ A ) ) ) ).

% compl_top_eq
thf(fact_201_is__singletonI,axiom,
    ! [A: $tType,X: A] : ( is_singleton @ A @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ).

% is_singletonI
thf(fact_202_bot__set__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A @ ( bot_bot @ ( A > $o ) ) ) ) ).

% bot_set_def
thf(fact_203_bot__empty__eq,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( A > $o ) )
      = ( ^ [X4: A] : ( member @ A @ X4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% bot_empty_eq
thf(fact_204_is__singletonI_H,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( A4
       != ( bot_bot @ ( set @ A ) ) )
     => ( ! [X5: A,Y3: A] :
            ( ( member @ A @ X5 @ A4 )
           => ( ( member @ A @ Y3 @ A4 )
             => ( X5 = Y3 ) ) )
       => ( is_singleton @ A @ A4 ) ) ) ).

% is_singletonI'
thf(fact_205_is__singleton__def,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A13: set @ A] :
          ? [X4: A] :
            ( A13
            = ( insert @ A @ X4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_def
thf(fact_206_is__singletonE,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( is_singleton @ A @ A4 )
     => ~ ! [X5: A] :
            ( A4
           != ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% is_singletonE
thf(fact_207_is__singleton__the__elem,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A13: set @ A] :
            ( A13
            = ( insert @ A @ ( the_elem @ A @ A13 ) @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_the_elem
thf(fact_208_remove__def,axiom,
    ! [A: $tType] :
      ( ( remove @ A )
      = ( ^ [X4: A,A13: set @ A] : ( minus_minus @ ( set @ A ) @ A13 @ ( insert @ A @ X4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% remove_def
thf(fact_209_member__remove,axiom,
    ! [A: $tType,X: A,Y: A,A4: set @ A] :
      ( ( member @ A @ X @ ( remove @ A @ Y @ A4 ) )
      = ( ( member @ A @ X @ A4 )
        & ( X != Y ) ) ) ).

% member_remove
thf(fact_210_the__elem__eq,axiom,
    ! [A: $tType,X: A] :
      ( ( the_elem @ A @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
      = X ) ).

% the_elem_eq
thf(fact_211_sum__set__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,X: A] :
      ( ( basic_setl @ A @ B @ ( sum_Inl @ A @ B @ X ) )
      = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ).

% sum_set_simps(1)
thf(fact_212_sum__set__simps_I4_J,axiom,
    ! [E: $tType,A: $tType,X: A] :
      ( ( basic_setr @ E @ A @ ( sum_Inr @ A @ E @ X ) )
      = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ).

% sum_set_simps(4)
thf(fact_213_sum__set__simps_I2_J,axiom,
    ! [A: $tType,C: $tType,X: A] :
      ( ( basic_setl @ C @ A @ ( sum_Inr @ A @ C @ X ) )
      = ( bot_bot @ ( set @ C ) ) ) ).

% sum_set_simps(2)
thf(fact_214_sum__set__simps_I3_J,axiom,
    ! [A: $tType,D: $tType,X: A] :
      ( ( basic_setr @ A @ D @ ( sum_Inl @ A @ D @ X ) )
      = ( bot_bot @ ( set @ D ) ) ) ).

% sum_set_simps(3)
thf(fact_215_setl_Ocases,axiom,
    ! [B: $tType,A: $tType,A5: A,S: sum_sum @ A @ B] :
      ( ( member @ A @ A5 @ ( basic_setl @ A @ B @ S ) )
     => ( S
        = ( sum_Inl @ A @ B @ A5 ) ) ) ).

% setl.cases
thf(fact_216_setl_Osimps,axiom,
    ! [B: $tType,A: $tType,A5: A,S: sum_sum @ A @ B] :
      ( ( member @ A @ A5 @ ( basic_setl @ A @ B @ S ) )
      = ( ? [X4: A] :
            ( ( A5 = X4 )
            & ( S
              = ( sum_Inl @ A @ B @ X4 ) ) ) ) ) ).

% setl.simps
thf(fact_217_setr_Ocases,axiom,
    ! [A: $tType,B: $tType,A5: B,S: sum_sum @ A @ B] :
      ( ( member @ B @ A5 @ ( basic_setr @ A @ B @ S ) )
     => ( S
        = ( sum_Inr @ B @ A @ A5 ) ) ) ).

% setr.cases
thf(fact_218_setr_Osimps,axiom,
    ! [A: $tType,B: $tType,A5: B,S: sum_sum @ A @ B] :
      ( ( member @ B @ A5 @ ( basic_setr @ A @ B @ S ) )
      = ( ? [X4: B] :
            ( ( A5 = X4 )
            & ( S
              = ( sum_Inr @ B @ A @ X4 ) ) ) ) ) ).

% setr.simps
thf(fact_219_setr_Ointros,axiom,
    ! [B: $tType,A: $tType,S: sum_sum @ A @ B,X: B] :
      ( ( S
        = ( sum_Inr @ B @ A @ X ) )
     => ( member @ B @ X @ ( basic_setr @ A @ B @ S ) ) ) ).

% setr.intros
thf(fact_220_setr_Oinducts,axiom,
    ! [A: $tType,B: $tType,X: B,S: sum_sum @ A @ B,P: B > $o] :
      ( ( member @ B @ X @ ( basic_setr @ A @ B @ S ) )
     => ( ! [X5: B] :
            ( ( S
              = ( sum_Inr @ B @ A @ X5 ) )
           => ( P @ X5 ) )
       => ( P @ X ) ) ) ).

% setr.inducts
thf(fact_221_setl_Oinducts,axiom,
    ! [B: $tType,A: $tType,X: A,S: sum_sum @ A @ B,P: A > $o] :
      ( ( member @ A @ X @ ( basic_setl @ A @ B @ S ) )
     => ( ! [X5: A] :
            ( ( S
              = ( sum_Inl @ A @ B @ X5 ) )
           => ( P @ X5 ) )
       => ( P @ X ) ) ) ).

% setl.inducts
thf(fact_222_setl_Ointros,axiom,
    ! [B: $tType,A: $tType,S: sum_sum @ A @ B,X: A] :
      ( ( S
        = ( sum_Inl @ A @ B @ X ) )
     => ( member @ A @ X @ ( basic_setl @ A @ B @ S ) ) ) ).

% setl.intros
thf(fact_223_Set_Ois__empty__def,axiom,
    ! [A: $tType] :
      ( ( is_empty @ A )
      = ( ^ [A13: set @ A] :
            ( A13
            = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Set.is_empty_def
thf(fact_224_remove__induct,axiom,
    ! [A: $tType,P: ( set @ A ) > $o,B4: set @ A] :
      ( ( P @ ( bot_bot @ ( set @ A ) ) )
     => ( ( ~ ( finite_finite2 @ A @ B4 )
         => ( P @ B4 ) )
       => ( ! [A10: set @ A] :
              ( ( finite_finite2 @ A @ A10 )
             => ( ( A10
                 != ( bot_bot @ ( set @ A ) ) )
               => ( ( ord_less_eq @ ( set @ A ) @ A10 @ B4 )
                 => ( ! [X6: A] :
                        ( ( member @ A @ X6 @ A10 )
                       => ( P @ ( minus_minus @ ( set @ A ) @ A10 @ ( insert @ A @ X6 @ ( bot_bot @ ( set @ A ) ) ) ) ) )
                   => ( P @ A10 ) ) ) ) )
         => ( P @ B4 ) ) ) ) ).

% remove_induct
thf(fact_225_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_226_subsetI,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ! [X5: A] :
          ( ( member @ A @ X5 @ A4 )
         => ( member @ A @ X5 @ B4 ) )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ B4 ) ) ).

% subsetI
thf(fact_227_subset__antisym,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( ord_less_eq @ ( set @ A ) @ B4 @ A4 )
       => ( A4 = B4 ) ) ) ).

% subset_antisym
thf(fact_228_empty__subsetI,axiom,
    ! [A: $tType,A4: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ A4 ) ).

% empty_subsetI
thf(fact_229_subset__empty,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( bot_bot @ ( set @ A ) ) )
      = ( A4
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% subset_empty
thf(fact_230_insert__subset,axiom,
    ! [A: $tType,X: A,A4: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( insert @ A @ X @ A4 ) @ B4 )
      = ( ( member @ A @ X @ B4 )
        & ( ord_less_eq @ ( set @ A ) @ A4 @ B4 ) ) ) ).

% insert_subset
thf(fact_231_Compl__anti__mono,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ord_less_eq @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ B4 ) @ ( uminus_uminus @ ( set @ A ) @ A4 ) ) ) ).

% Compl_anti_mono
thf(fact_232_Compl__subset__Compl__iff,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( uminus_uminus @ ( set @ A ) @ A4 ) @ ( uminus_uminus @ ( set @ A ) @ B4 ) )
      = ( ord_less_eq @ ( set @ A ) @ B4 @ A4 ) ) ).

% Compl_subset_Compl_iff
thf(fact_233_Pow__iff,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( member @ ( set @ A ) @ A4 @ ( pow @ A @ B4 ) )
      = ( ord_less_eq @ ( set @ A ) @ A4 @ B4 ) ) ).

% Pow_iff
thf(fact_234_PowI,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( member @ ( set @ A ) @ A4 @ ( pow @ A @ B4 ) ) ) ).

% PowI
thf(fact_235_singleton__insert__inj__eq_H,axiom,
    ! [A: $tType,A5: A,A4: set @ A,B2: A] :
      ( ( ( insert @ A @ A5 @ A4 )
        = ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( A5 = B2 )
        & ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% singleton_insert_inj_eq'
thf(fact_236_singleton__insert__inj__eq,axiom,
    ! [A: $tType,B2: A,A5: A,A4: set @ A] :
      ( ( ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ A5 @ A4 ) )
      = ( ( A5 = B2 )
        & ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% singleton_insert_inj_eq
thf(fact_237_Diff__eq__empty__iff,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ( minus_minus @ ( set @ A ) @ A4 @ B4 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ord_less_eq @ ( set @ A ) @ A4 @ B4 ) ) ).

% Diff_eq_empty_iff
thf(fact_238_subset__Compl__singleton,axiom,
    ! [A: $tType,A4: set @ A,B2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( uminus_uminus @ ( set @ A ) @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ~ ( member @ A @ B2 @ A4 ) ) ) ).

% subset_Compl_singleton
thf(fact_239_bot_Oextremum__uniqueI,axiom,
    ! [A: $tType] :
      ( ( order_bot @ A @ ( type2 @ A ) )
     => ! [A5: A] :
          ( ( ord_less_eq @ A @ A5 @ ( bot_bot @ A ) )
         => ( A5
            = ( bot_bot @ A ) ) ) ) ).

% bot.extremum_uniqueI
thf(fact_240_bot_Oextremum__unique,axiom,
    ! [A: $tType] :
      ( ( order_bot @ A @ ( type2 @ A ) )
     => ! [A5: A] :
          ( ( ord_less_eq @ A @ A5 @ ( bot_bot @ A ) )
          = ( A5
            = ( bot_bot @ A ) ) ) ) ).

% bot.extremum_unique
thf(fact_241_bot_Oextremum,axiom,
    ! [A: $tType] :
      ( ( order_bot @ A @ ( type2 @ A ) )
     => ! [A5: A] : ( ord_less_eq @ A @ ( bot_bot @ A ) @ A5 ) ) ).

% bot.extremum
thf(fact_242_subset__singletonD,axiom,
    ! [A: $tType,A4: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) )
     => ( ( A4
          = ( bot_bot @ ( set @ A ) ) )
        | ( A4
          = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% subset_singletonD
thf(fact_243_subset__singleton__iff,axiom,
    ! [A: $tType,X8: set @ A,A5: A] :
      ( ( ord_less_eq @ ( set @ A ) @ X8 @ ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( X8
          = ( bot_bot @ ( set @ A ) ) )
        | ( X8
          = ( insert @ A @ A5 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% subset_singleton_iff
thf(fact_244_subset__Compl__self__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ ( uminus_uminus @ ( set @ A ) @ A4 ) )
      = ( A4
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% subset_Compl_self_eq
thf(fact_245_Pow__mono,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ord_less_eq @ ( set @ ( set @ A ) ) @ ( pow @ A @ A4 ) @ ( pow @ A @ B4 ) ) ) ).

% Pow_mono
thf(fact_246_PowD,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( member @ ( set @ A ) @ A4 @ ( pow @ A @ B4 ) )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ B4 ) ) ).

% PowD
thf(fact_247_inItr__mono,axiom,
    ! [Ns: set @ n,Tr: dtree,N3: n,Ns4: set @ n] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N3 )
     => ( ( ord_less_eq @ ( set @ n ) @ Ns @ Ns4 )
       => ( gram_L830233218_inItr @ Ns4 @ Tr @ N3 ) ) ) ).

% inItr_mono
thf(fact_248_inFr2__mono,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t,Ns4: set @ n] :
      ( ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 )
     => ( ( ord_less_eq @ ( set @ n ) @ Ns @ Ns4 )
       => ( gram_L805317441_inFr2 @ Ns4 @ Tr @ T2 ) ) ) ).

% inFr2_mono
thf(fact_249_set__mp,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( member @ A @ X @ A4 )
       => ( member @ A @ X @ B4 ) ) ) ).

% set_mp
thf(fact_250_in__mono,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( member @ A @ X @ A4 )
       => ( member @ A @ X @ B4 ) ) ) ).

% in_mono
thf(fact_251_subsetD,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,C3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( member @ A @ C3 @ A4 )
       => ( member @ A @ C3 @ B4 ) ) ) ).

% subsetD
thf(fact_252_subsetCE,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A,C3: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
     => ( ( member @ A @ C3 @ A4 )
       => ( member @ A @ C3 @ B4 ) ) ) ).

% subsetCE
thf(fact_253_equalityE,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( A4 = B4 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A4 @ B4 )
         => ~ ( ord_less_eq @ ( set @ A ) @ B4 @ A4 ) ) ) ).

% equalityE
thf(fact_254_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A13: set @ A,B10: set @ A] :
          ! [X4: A] :
            ( ( member @ A @ X4 @ A13 )
           => ( member @ A @ X4 @ B10 ) ) ) ) ).

% subset_eq
thf(fact_255_equalityD1,axiom,
    ! [A: $tType,A4: set @ A,B4: set @ A] :
      ( ( A4 = B4 )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ B4 ) ) ).

% equalityD1

%----Type constructors (21)
thf(tcon_fun___Lattices_Oboolean__algebra,axiom,
    ! [A7: $tType,A14: $tType] :
      ( ( boolean_algebra @ A14 @ ( type2 @ A14 ) )
     => ( boolean_algebra @ ( A7 > A14 ) @ ( type2 @ ( A7 > A14 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder__bot,axiom,
    ! [A7: $tType,A14: $tType] :
      ( ( order_bot @ A14 @ ( type2 @ A14 ) )
     => ( order_bot @ ( A7 > A14 ) @ ( type2 @ ( A7 > A14 ) ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A14: $tType] :
      ( ( preorder @ A14 @ ( type2 @ A14 ) )
     => ( preorder @ ( A7 > A14 ) @ ( type2 @ ( A7 > A14 ) ) ) ) ).

thf(tcon_fun___Finite__Set_Ofinite,axiom,
    ! [A7: $tType,A14: $tType] :
      ( ( ( finite_finite @ A7 @ ( type2 @ A7 ) )
        & ( finite_finite @ A14 @ ( type2 @ A14 ) ) )
     => ( finite_finite @ ( A7 > A14 ) @ ( type2 @ ( A7 > A14 ) ) ) ) ).

thf(tcon_fun___Orderings_Otop,axiom,
    ! [A7: $tType,A14: $tType] :
      ( ( top @ A14 @ ( type2 @ A14 ) )
     => ( top @ ( A7 > A14 ) @ ( type2 @ ( A7 > A14 ) ) ) ) ).

thf(tcon_fun___Orderings_Obot,axiom,
    ! [A7: $tType,A14: $tType] :
      ( ( bot @ A14 @ ( type2 @ A14 ) )
     => ( bot @ ( A7 > A14 ) @ ( type2 @ ( A7 > A14 ) ) ) ) ).

thf(tcon_Set_Oset___Lattices_Oboolean__algebra_1,axiom,
    ! [A7: $tType] : ( boolean_algebra @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder__bot_2,axiom,
    ! [A7: $tType] : ( order_bot @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_3,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Finite__Set_Ofinite_4,axiom,
    ! [A7: $tType] :
      ( ( finite_finite @ A7 @ ( type2 @ A7 ) )
     => ( finite_finite @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ) ).

thf(tcon_Set_Oset___Orderings_Otop_5,axiom,
    ! [A7: $tType] : ( top @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Obot_6,axiom,
    ! [A7: $tType] : ( bot @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Oboolean__algebra_7,axiom,
    boolean_algebra @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder__bot_8,axiom,
    order_bot @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_9,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Finite__Set_Ofinite_10,axiom,
    finite_finite @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Otop_11,axiom,
    top @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Obot_12,axiom,
    bot @ $o @ ( type2 @ $o ) ).

thf(tcon_Sum__Type_Osum___Finite__Set_Ofinite_13,axiom,
    ! [A7: $tType,A14: $tType] :
      ( ( ( finite_finite @ A7 @ ( type2 @ A7 ) )
        & ( finite_finite @ A14 @ ( type2 @ A14 ) ) )
     => ( finite_finite @ ( sum_sum @ A7 @ A14 ) @ ( type2 @ ( sum_sum @ A7 @ A14 ) ) ) ) ).

thf(tcon_Option_Ooption___Finite__Set_Ofinite_14,axiom,
    ! [A7: $tType] :
      ( ( finite_finite @ A7 @ ( type2 @ A7 ) )
     => ( finite_finite @ ( option @ A7 ) @ ( type2 @ ( option @ A7 ) ) ) ) ).

thf(tcon_Product__Type_Oprod___Finite__Set_Ofinite_15,axiom,
    ! [A7: $tType,A14: $tType] :
      ( ( ( finite_finite @ A7 @ ( type2 @ A7 ) )
        & ( finite_finite @ A14 @ ( type2 @ A14 ) ) )
     => ( finite_finite @ ( product_prod @ A7 @ A14 ) @ ( type2 @ ( product_prod @ A7 @ A14 ) ) ) ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $true @ X @ Y )
      = X ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    gram_L864798063lle_wf @ tr ).

%------------------------------------------------------------------------------
